import React, {Component} from 'react';
import PropTypes from 'prop-types';
import HabitatList from "./HabitatsList";
import {compose} from "redux";
import {graphql} from "react-apollo";
import {authUserQuery, monitoraggioHabitatsQuery} from '../../../../api/queries'
import { deleteMonitoraggioHabitatMutation } from '../../../../api/mutation'

export class HabitatsListContainer extends Component {
  render() {
    return (
      <HabitatList {...this.props} />
    )
  }
}

export default compose(
  graphql(monitoraggioHabitatsQuery, {
    variables: {
      filtro: "",
      pagination: {
        limit: 50,
        offset: 0
      }
    }
  }),
  graphql(deleteMonitoraggioHabitatMutation),
  graphql(authUserQuery, {name: 'utenteSessione'})
)(HabitatsListContainer);

HabitatsListContainer.defaultProps = {};

HabitatsListContainer.propTypes = {};